﻿#region << Using Directives >>
using System;
#endregion

namespace Volpe.Cafe.Generic
{
    /// <summary>
    /// Represents an object that stores compliance modeling data for each regulatory class. This object supports deep member
    /// cloning by requiring that each variable of this generic class implement the <see cref="ICloneable"/> interface.
    /// </summary>
    [Serializable]
    public class RCObject<T> : RCValue<T>, ICloneable where T : ICloneable
    {

        #region /*** Ctors ***/

        /// <summary>
        /// Initializes a new instance of the <see cref="RCObject{T}"/> class.
        /// </summary>
        public RCObject() : base() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="RCObject{T}"/> class using the specified values.
        /// </summary>
        public RCObject(T passengerCar, T lightTruck, T lightTruck2b3) : base(passengerCar, lightTruck, lightTruck2b3) { }

        #endregion

        #region /*** Methods ***/

        #region /* ICloneable Members */

        /// <summary>
        /// Creates a copy of the current <see cref="RCObject{T}"/> instance.
        /// </summary>
        /// <returns>A new object that is a copy of this <see cref="RCObject{T}"/>.</returns>
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        /// <summary>
        /// Creates a copy of the current <see cref="RCObject{T}"/> instance.
        /// </summary>
        /// <returns>A new object that is a copy of this <see cref="RCObject{T}"/>.</returns>
        public new RCObject<T> Clone()
        {
            RCObject<T> value = new RCObject<T>();
            this.CopyTo(value);
            return value;
        }
        /// <summary>
        /// Copies the members of the current <see cref="RCObject{T}"/> instance into the specified value.
        /// </summary>
        /// <param name="value">The value where to copy the members of the current instance.</param>
        protected void CopyTo(RCObject<T> value)
        {
            for (int i = 0; i < this.Items.Length; i++)
            {
                value.Items[i] = (T)this.Items[i].Clone();
            }
        }

        #endregion

        #endregion

    }
}
